/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.frame;

import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.OmUtils;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.objmgr.sys.OmSysAsyncEvtHandler;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class OmFrameAsyncHandler
extends OmSysAsyncEvtHandler {
    private static final byte[] FSP_EVENT_REG_MASK = new byte[]{3, 0, 19, -2};
    private static final int FSP_PFT_EVT_LOG_EVT_BIT = 6;
    private static final int FSP_PFT_DUMP_EVT_BIT = 7;
    private static final int FSP_CEC_NAME_CHANGE_EVT_BIT = 19;
    private static final int BPA_ENV_CHANGE_EVT_BIT = 22;
    private static final int BPA_FNM_ERROR_EVT_BIT = 23;
    private static final int BPA_FED_SWITCH_EVT_BIT = 24;
    private static final int BPA_FRU_LED_EVT_BIT = 25;
    private static final int BPA_FRAME_NUM_EVT_BIT = 26;
    private static final int BPA_FRAME_INFO_EVT_BIT = 27;
    private static final int BPA_ACT_FRU_READY_EVT_BIT = 28;
    private static final int BPA_BPC_STATE_EVT_BIT = 29;
    private static final int BPA_ACDL_STATUS_EVT_BIT = 30;
    protected static final int BPA_MSG_PASSING_STATE_OPCODE = 40981;
    protected static final int BPA_ENV_CHANGE_OPCODE = 40982;
    protected static final int BPA_FNM_ERROR_OPCODE = 40983;
    protected static final int BPA_FED_SWITCH_OPCODE = 40984;
    protected static final int BPA_FRU_LED_OPCODE = 40985;
    protected static final int BPA_FRAME_NUM_OPCODE = 40986;
    protected static final int BPA_FRAME_INFO_OPCODE = 40987;
    protected static final int BPA_ACT_FRU_READY_OPCODE = 40988;
    protected static final int BPA_BPC_STATE_OPCODE = 40989;
    protected static final int BPA_ACDL_STATUS_OPCODE = 40990;
    private static final String ASYNC_ACDL_STATUS = "ASYNC_ACDL_STATUS";
    private OmFrameMgr mFrameMgr;

    public OmFrameAsyncHandler(OmSysMgr omSysMgr) {
        super(omSysMgr);
        this.mFrameMgr = (OmFrameMgr)omSysMgr;
    }

    public void reinitialize() {
        try {
            System.out.println("send down event mask sub");
            this.mSysMgr.getCmdHelper().setEventNotificationMask(FSP_EVENT_REG_MASK);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        boolean bl = false;
        try {
            System.out.println("Handles event for " + this.mSysMgr.getSysName() + " minorCode is " + n);
            PIParseResponse pIParseResponse = new PIParseResponse(byArray2);
            System.out.println("after parse response");
            int n2 = pIParseResponse.getTarget();
            int n3 = pIParseResponse.getOpCode();
            System.out.println("target: " + n2 + " opcode: " + n3);
            if (n2 == 28672 && n3 == 1) {
                System.out.println("fsp event");
                try {
                    this.handleFSPEvent(pIParseResponse, byArray);
                }
                finally {
                    this.acknowledgeFspEvent();
                }
            }
            if (n2 == 28672 && n3 == 40985) {
                System.out.println("got an event bpc fru led state change");
                this.handleFruLedEvent(pIParseResponse);
            }
            if (n2 == 28672 && n3 == 40986) {
                System.out.println("got an event bpc frame num change");
                this.handleFrameNumChange();
            }
            if (n2 == 28672 && n3 == 40987) {
                System.out.println("got an event bpc frame info change");
                this.handleFrameInfoChange();
            }
            if (n2 == 28672 && n3 == 40988) {
                System.out.println("got an event act fru ready");
                this.handleActFruReadyEvent(pIParseResponse);
            }
            if (n2 == 28672 && n3 == 40989) {
                System.out.println("got an event bpc state change");
                this.handleBpcStateChange();
            }
            if (n2 == 28672 && n3 == 40990) {
                System.out.println("got an event acdl");
                this.handleAcdlEvent(pIParseResponse);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void handleFSPEvent(PIParseResponse pIParseResponse, byte[] byArray) throws Exception {
        Hashtable hashtable = pIParseResponse.getParsedData("ASYNC_EVENT_NOTIFICATION");
        byte[] byArray2 = (byte[])hashtable.get("DATA");
        boolean bl = false;
        OmUtils omUtils = OmUtils.getInstance();
        if (omUtils.isBitOnInByteArray(byArray2, 6)) {
            System.out.println("got an event bpc platform event log");
            this.handlePlatformLogEvent(byArray);
        }
        if (omUtils.isBitOnInByteArray(byArray2, 7)) {
            System.out.println("got an event bpc platform dump");
            this.handlePlatformDumpEvent(byArray);
        }
        if (omUtils.isBitOnInByteArray(byArray2, 19)) {
            System.out.println("got an event fsp cec name change");
            this.handleUserDefNameChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUserDefNameChange() {
        block11: {
            Lock lock = null;
            try {
                try {
                    lock = Lock.getInstance("root/ibmhscS1_0", this.mFrameMgr.getSysName());
                    lock.lock(4);
                    this.mFrameMgr.userDefNameChanged();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var4_3 = null;
                    if (lock == null) {
                        System.out.println("could not get lock  in bpa usr def name event handler");
                        return;
                    }
                    try {
                        lock.unlock();
                        System.out.println("released the cimom cec lock in bpa usr def name event handler");
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        return;
                    }
                }
                Object var4_2 = null;
                if (lock == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (lock == null) {
                    System.out.println("could not get lock  in bpa usr def name event handler");
                    throw throwable;
                }
                try {}
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    throw throwable;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock in bpa usr def name event handler");
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in bpa usr def name event handler");
            return;
        }
        System.out.println("could not get lock  in bpa usr def name event handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleFrameNumChange() {
        block11: {
            Lock lock = null;
            try {
                try {
                    lock = Lock.getInstance("root/ibmhscS1_0", this.mFrameMgr.getSysName());
                    lock.lock(4);
                    this.mFrameMgr.frameNumChanged();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var4_3 = null;
                    if (lock == null) {
                        System.out.println("could not get lock  in bpa frame num event handler");
                        return;
                    }
                    try {
                        lock.unlock();
                        System.out.println("released the cimom cec lock in bpa frame num event handler");
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        return;
                    }
                }
                Object var4_2 = null;
                if (lock == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (lock == null) {
                    System.out.println("could not get lock  in bpa frame num event handler");
                    throw throwable;
                }
                try {}
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    throw throwable;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock in bpa frame num event handler");
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in bpa frame num event handler");
            return;
        }
        System.out.println("could not get lock  in bpa frame num event handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleFrameInfoChange() {
        block11: {
            Lock lock = null;
            try {
                try {
                    lock = Lock.getInstance("root/ibmhscS1_0", this.mFrameMgr.getSysName());
                    lock.lock(4);
                    this.mFrameMgr.frameInfoChanged();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var4_3 = null;
                    if (lock == null) {
                        System.out.println("could not get lock  in bpa frame info event handler");
                        return;
                    }
                    try {
                        lock.unlock();
                        System.out.println("released the cimom cec lock in bpa frame info event handler");
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        return;
                    }
                }
                Object var4_2 = null;
                if (lock == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (lock == null) {
                    System.out.println("could not get lock  in bpa frame info event handler");
                    throw throwable;
                }
                try {}
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    throw throwable;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock in bpa frame info event handler");
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in bpa frame info event handler");
            return;
        }
        System.out.println("could not get lock  in bpa frame info event handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleBpcStateChange() {
        block11: {
            Lock lock = null;
            try {
                try {
                    lock = Lock.getInstance("root/ibmhscS1_0", this.mFrameMgr.getSysName());
                    lock.lock(4);
                    this.mFrameMgr.bpcStateChanged();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var4_3 = null;
                    if (lock == null) {
                        System.out.println("could not get lock  in bpc state event handler");
                        return;
                    }
                    try {
                        lock.unlock();
                        System.out.println("released the cimom cec lock in bpc state event handler");
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                        return;
                    }
                }
                Object var4_2 = null;
                if (lock == null) break block11;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (lock == null) {
                    System.out.println("could not get lock  in bpc state event handler");
                    throw throwable;
                }
                try {}
                catch (Throwable throwable3) {
                    throwable3.printStackTrace();
                    throw throwable;
                }
                lock.unlock();
                System.out.println("released the cimom cec lock in bpc state event handler");
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            lock.unlock();
            System.out.println("released the cimom cec lock in bpc state event handler");
            return;
        }
        System.out.println("could not get lock  in bpc state event handler");
    }

    private void handleFruLedEvent(PIParseResponse pIParseResponse) {
    }

    private void handleActFruReadyEvent(PIParseResponse pIParseResponse) {
    }

    private void handleAcdlEvent(PIParseResponse pIParseResponse) {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        try {
            System.out.println("resp: " + pIParseResponse);
            Hashtable hashtable2 = pIParseResponse.getParsedData(ASYNC_ACDL_STATUS);
            System.out.println("acdlData: " + hashtable2);
            short s = ((UnsignedInt8)hashtable2.get("BPA_SIDE")).shortValue();
            short s2 = ((UnsignedInt8)hashtable2.get("SYSTEM_STATUS_MODE")).shortValue();
            short s3 = ((UnsignedInt8)hashtable2.get("SYSTEM_STATUS_PROGRESS")).shortValue();
            short s4 = ((UnsignedInt8)hashtable2.get("FRU_COMPLETED")).shortValue();
            short s5 = ((UnsignedInt8)hashtable2.get("FRU_TO_LOAD")).shortValue();
            hashtable.put(new Short(s), "BPA_SIDE");
            hashtable.put(new Short(s2), "SYSTEM_STATUS_MODE");
            hashtable.put(new Short(s3), "SYSTEM_STATUS_PROGRESS");
            hashtable.put(new Short(s4), "FRU_COMPLETED");
            hashtable.put(new Short(s5), "FRU_TO_LOAD");
            Object[] objectArray = (Object[])hashtable2.get("CODE_LEVEL_LIST");
            int n = objectArray.length;
            String[] stringArray = new String[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            if (objectArray != null) {
                System.out.println("frulist.length: " + objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    Hashtable hashtable3 = (Hashtable)objectArray[i];
                    nArray[i] = ((UnsignedInt8)hashtable3.get("FRU_STATUS")).intValue();
                    stringArray[i] = (String)hashtable3.get("LOC_CODE");
                    System.out.println("The location code is :" + stringArray[i]);
                    nArray2[i] = ((UnsignedInt16)hashtable3.get("ACT_CODE_LEVEL")).intValue();
                    System.out.println("The actual code level is :" + nArray2[i]);
                    nArray3[i] = ((UnsignedInt16)hashtable3.get("EXPECTED_CODE_LEVEL")).intValue();
                    System.out.println("The expected code level is :" + nArray3[i]);
                    UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable3.get("ACT_CODE_LEVEL1");
                    nArray4[i] = unsignedInt16 == null ? 0 : unsignedInt16.intValue();
                    System.out.println("The actual code level 1 is :" + nArray4[i]);
                    UnsignedInt16 unsignedInt162 = (UnsignedInt16)hashtable3.get("EXPECTED_CODE_LEVEL1");
                    nArray5[i] = unsignedInt162 == null ? 0 : unsignedInt162.intValue();
                    System.out.println("The expected code level 1 is :" + nArray5[i]);
                }
            }
            hashtable.put(stringArray, "LOC_CODE");
            hashtable.put(nArray, "FRU_STATUS");
            hashtable.put(nArray2, "ACT_CODE_LEVEL");
            hashtable.put(nArray3, "EXPECTED_CODE_LEVEL");
            hashtable.put(nArray4, "ACT_CODE_LEVEL1");
            hashtable.put(nArray5, "EXPECTED_CODE_LEVEL1");
        }
        catch (Throwable throwable) {
            System.out.println("GOT an exception parsing ACDL Async Event");
            throwable.printStackTrace();
        }
        HSCEventIndicationMgr.getInstance().sendIndication(305, this.mSysMgr.getObject(), null);
    }

    public void handleError(Throwable throwable) {
        throwable.printStackTrace();
    }
}

